# Genetic analyses

rm(list=ls())

# necessary libraries 

rm(list=ls())

library(adegenet)
library(ape)
library(hierfstat)
library(pegas)
library(poppr)
library(tidyverse)

# Read in the SNP dataset
AllSNPs <- read.genepop(file= "./Filtered.snps.gen")

# Set populations names
popNames(AllSNPs)
popNames(AllSNPs) <- c("a_Bhadid_Luachraich", "a_Garbh_bhaid_Mor","Ard_Achadh", "Arkaig_Bn", "Arkaig_Pl",
                          "Awe_Bn", "Awe_Pl", "Bodlyn", "Braig_Horrisdale", "Brora", "Bruicheach",
                          "Bunaveela", "Calder", "Conniston", "Coulin", "Damh", "Doine", "Doon", "Dubh", 
                          "Dughaill_Bn", "Dughaill_Pl", "Duntelchaig", "Earn", "Eck", "Ericht_Bn", "Ericht_Pl",
                          "Fannich", "Finn", "Garry", "Insh", "Kindrum", "Laggan", "Langavat", 
                          "Lee", "Loch", "Lochy_Bn", "Lochy_Pl", "Lubnaig", "Luichart", "Maree",
                          "Meadie", "Mealt", "Merkland", "More", "Morie", "Nam_Brac", "naSealga_Pl", 
                          "naSealga_Bn", "Naver", "Osgaig", "Padarn", "Rannoch_Bn", "Rannoch_Pl",
                          "Rannoch_Ps", "Seil", "Shin", "Stack", "Talla", "Tarff", "Tay_Bn", "Tay_Pl",
                          "Treig", "Tummel", "Uaine")
popNames(AllSNPs)

#### N-J tree #####
# Remove SNPs with missing data to prevent effect on N-J tree
AllSNPs.no.NA <- missingno(AllSNPs, type = "loci")

# Read in Strata list
pop <- read.csv("./Strata_list.csv")
strata(AllSNPs.no.NA)  <- pop
setPop(AllSNPs.no.NA) ~Pop
tree <- aboot(AllSNPs.no.NA, strata = ~Pop, distance = "edwards.dist",tree = "nj", sample = 1000, cex.names =2, cutoff = 50)

plot.phylo(tree, type = "unrooted", use.edge.length= F, lab4ut="axial", cex= 0.6)
plot(tree, "u", use.edge.length= F)

### AMOVA ###

strata(AllSNPs)  <- pop
setPop(AllSNPs) <- ~Pop/HA/east_west


amova.results <- poppr.amova(AllSNPs, hier = ~east_west/HA/Pop)
amova.results

amova.test <- randtest(amova.results, nrepet= 999)
plot(amova.test)
amova.test

### Allelic richness ###
allelic.richness(AllSNPs)
# Change as needed for each population
aBL.rich <- mean(na.omit(AR$Ar[,1]))

