clear all
a = load('Q_eng_d1=130.mat');
k = a.kpoints/pi;
freqs = a.freqs;
Qs = a.Qs;



[nk, nm] = size(freqs);
kk = -freqs
nk = nk/200;
% xt = 
% 假设你已经有 Qs, freqs 等数据
Qs_clipped = Qs;
Qs_clipped(Qs > 1e10) = NaN;  % 将超大 Q 设为 NaN（方便 mask）

% 创建颜色映射（log scale）
cmap = colormap(slanCM('plasma')) ;
figure; hold on;
offs = 0.00;
for m = 1:size(freqs,2)
    % 主图：绘制 log(Q) 部分
    scatter(0.005:0.005:nk, freqs(:,m)+offs, 25, log10(Qs_clipped(:,m)), 'filled');

    % 绘制 Q=inf 的点（灰色）
    mask_inf = Qs(:,m) > 10^15;
   
    scatter(find(mask_inf)/200, freqs(mask_inf,m)+offs, 25, 'yellow', 'filled');  % 灰色

    % plot(1:nk, freqs(:,m)+offs, 'LineStyle','--');  % 能带轮廓
end
hold on 
for m = 1:size(freqs,2)
    % 主图：绘制 log(Q) 部分
    scatter(-0.005:-0.005:-nk, freqs(:,m)+offs, 25, log10(Qs_clipped(:,m)), 'filled');

    % 绘制 Q=inf 的点（灰色）
    mask_inf = Qs(:,m) > 10^15;
   
    scatter(find(mask_inf)/200, freqs(mask_inf,m)+offs, 25, 'yellow', 'filled');  % 灰色

    % plot(1:nk, freqs(:,m)+offs, 'LineStyle','--');  % 能带轮廓
end

 colormap(slanCM('plasma')) ;
cb = colorbar;
cb.Label.String = 'log_{10}(Q)';
% ylabel('\omega a / 2\pi c');
% xlabel('k-point index');
% title('Band structure with Q coloring');
xticks([ ])
box on; 

% 设置颜色范围
caxis([log10(10^1), log10(10^10)]);  % 可按你的数据调节
ylim([0.435 0.445])
xlim([-1/1.5 1/1.5])
set(gca, 'LineWidth', 2);
set(gca, 'FontSize', 25,'FontWeight','bold');