function fetchWaybackData() {
  var spreadsheet = SpreadsheetApp.getActiveSpreadsheet();
  var sheetName = "++++++++++++++++";
  var sheet = spreadsheet.getSheetByName(sheetName);
  
  // Specify the name of your spreadsheet within sheetName, where the plus symbols are located.

  if (!sheet) {
    Logger.log("Error: Sheet '" + sheetName + "' not found.");
    return;
  }

  var urls = [ 

  ];

  var properties = PropertiesService.getScriptProperties();
  var lastIndex = parseInt(properties.getProperty("lastIndex")) || 0;
  var batchSize = 10;

  Logger.log("Processing URLs from index: " + lastIndex);

  var results = [];

  for (var i = lastIndex; i < Math.min(lastIndex + batchSize, urls.length); i++) {
    var url = urls[i];
    var apiUrl = "https://archive.org/wayback/available?url=" + encodeURIComponent(url);

    try {
      var response = UrlFetchApp.fetch(apiUrl);
      var data = JSON.parse(response.getContentText());

      var snapshot = (data.archived_snapshots && data.archived_snapshots.closest) ? data.archived_snapshots.closest : {};

      results.push([
        url,
        snapshot.available ? snapshot.url : "No Wayback archive found",
        snapshot.timestamp || "N/A",
        snapshot.status || "N/A"
      ]);
    } catch (error) {
      Logger.log("Error fetching data for " + url + ": " + error);
      results.push([url, "Error fetching data", "N/A", "N/A"]);
    }
  }

  if (results.length > 0) {
    sheet.getRange(sheet.getLastRow() + 1, 1, results.length, results[0].length).setValues(results);
    Logger.log("Successfully wrote data to the spreadsheet.");
  } else {
    Logger.log("No results to write to the spreadsheet.");
  }

  lastIndex += batchSize;
  if (lastIndex >= urls.length) {
    properties.deleteProperty("lastIndex");
    Logger.log("Finished processing all URLs.");
  } else {
    properties.setProperty("lastIndex", lastIndex);
    Logger.log("Saved progress at index: " + lastIndex);
    scheduleNextRun(); // Schedule next run in 2 minutes -- Wayback Machine API will often fail to respond if too many calls are performed in quick succession.
  }
}

// Schedules the next execution in 2 minutes

function scheduleNextRun() {
  ScriptApp.newTrigger("fetchWaybackData")
    .timeBased()
    .after(2 * 60 * 1000) // 2 minutes
    .create();
}