function fetchData() {
  var sheet = SpreadsheetApp.getActiveSpreadsheet().getSheetByName("+++++++++");
  if (!sheet) {
    Logger.log("Sheet '+++++++++' not found!");
    return;
  }
  
  // Specify active spreadsheet above within plus symbols. Failure to locate sheet logged here.

  var countryCodes = ["ad", "al", "at", "ba", "be", "bg", "by", "ch", "cy", "cz", "de", "dk", "ee", "es", "fi", "fr", "gb", "gr", "hr", "hu", "ie", "is", "it", "lt", "lu", "lv", "mc", "md", "me", "mk", "mt", "nl", "no", "pl", "pt", "ro", "rs", "ru", "se", "si", "sk", "sm", "ua", "va"]; 
  
  // ISO 3166-1 alpha-2 country codes used as a filter with the Sherpa API for OpenDOAR.

  var baseURL = "https://v2.sherpa.ac.uk/cgi/retrieve?item-type=repository&api-key=++++++++++++++++++&format=Json&filter=";
  var limit = 50;
  
  // Plug-in Sherpa API authorization key within baseURL -- be sure to retain parameters.

  countryCodes.forEach(countryCode => {
    var offset = 0;
    var hasMoreData = true;

    while (hasMoreData) {
      var url = `${baseURL}[[%22country%22,%22equals%22,%22${countryCode}%22]]&limit=${limit}&offset=${offset}`;
      var response = UrlFetchApp.fetch(url);
      var data = JSON.parse(response.getContentText());

      Logger.log(`Country: ${countryCode}, Raw API response: ${JSON.stringify(data, null, 2)}`);

      if (data.items && data.items.length > 0) {
        var rows = data.items.map(item => [
          item.system_metadata?.id || "N/A",
          item.repository_metadata?.name?.[0]?.name || "Unknown",
          item.repository_metadata?.url || "Unknown",
          item.repository_metadata?.oai_url || "Unknown",
          item.repository_metadata?.type || "Unknown",
          item.repository_metadata?.software?.name || "Unknown",
          item.organisation?.country || "Unknown",
          countryCode // Include alpha-2 country code for reference
        ]);

        Logger.log(`Extracted rows for ${countryCode}: ${JSON.stringify(rows, null, 2)}`);

        if (rows.length > 0) {
          var startRow = Math.max(1, sheet.getLastRow() + 1);
          sheet.getRange(startRow, 1, rows.length, rows[0].length).setValues(rows);
          Logger.log(`Successfully wrote ${rows.length} rows for ${countryCode}.`);
        } else {
          Logger.log(`No valid rows to write for ${countryCode}.`);
        }

        offset += limit;
      } else {
        Logger.log(`No data received for ${countryCode}, stopping pagination.`);
        hasMoreData = false;
      }
    }
  });

  Logger.log("Finished fetching data for all alpha-2 country codes.");
}
