function getStatusCode(url) {
  var options = {
    'muteHttpExceptions': true,
    'followRedirects': false
  };

  var url_trimmed = url.trim();
  var response = UrlFetchApp.fetch(url_trimmed, options);
  var statusCode = response.getResponseCode();

  if (statusCode == 301) {
    // Follow the redirect
    var followOptions = { 'muteHttpExceptions': true, 'followRedirects': true };
    var finalResponse = UrlFetchApp.fetch(url_trimmed, followOptions);
    var finalUrl = finalResponse.getHeaders()['Location'] || url_trimmed;

    // Normalize URLs for comparison
    var normalizedOriginalUrl = url_trimmed.replace(/^http:/, "https:");
    var normalizedFinalUrl = finalUrl.replace(/^http:/, "https:");

    if (normalizedOriginalUrl === normalizedFinalUrl) {
      return 200; // Treat as OK since it's just an HTTP-to-HTTPS transition
    }
  }

  return statusCode;
}

// Script inspired by Adham El Banhawy's "How to use Google spreadsheets to check for broken links" [Medium], https://banhawy.medium.com/how-to-use-google-spreadsheets-to-check-for-broken-links-1bb0b35c8525 - thanks @g3om4c