function callRestApi() {
  var baseUrls = [
"repository.location.ac.uk",
"another.repository.location.ac.uk"
  ]; // Base URLs of target 'dead' repositories within inverted commas, e.g. "eprints.gla.ac.uk"

  var sheet = SpreadsheetApp.getActiveSpreadsheet();
  var limit = 20; // API-defined limit, adjustable
  var scroll = true;

  baseUrls.forEach(domain => {
    var scrollId = null; // Reset per domain
    var moreData = true;

    while (moreData) {
      var query = encodeURIComponent(`(fullText:"http://${domain}/*" OR fullText:"https://${domain}/*")`);
      var urlApi = `https://api.core.ac.uk/v3/search/works?q=${query}&limit=${limit}&scroll=${true}`;

      if (scrollId) {
        urlApi += `&scrollId=${scrollId}`;
      }

      var options = {
        method: "get",
        muteHttpExceptions: true,
        headers: {
          "Authorization": "+++++++++++++++++++",
          "Content-Type": "application/json"
        }
      }; // API authorization code required from core.ac.uk, where plus symbols are present

      try {
        var response = UrlFetchApp.fetch(urlApi, options);
        var json = response.getContentText();
        Logger.log("Raw API Response: " + json);
        var data = JSON.parse(json);

        if (data.results && data.results.length > 0) {
          data.results.forEach(result => {
            var fullText = result.fullText || "";
            
            // Extract full URLs using regex
            var urlRegex = new RegExp(`https?:\\/\\/${domain}\\/[^\\s"]+`, "g");
            var extractedUrls = fullText.match(urlRegex) || [];

            Logger.log(`Extracted URLs for ${domain}: ` + extractedUrls.join(", "));

            var dataProviders = result.dataProviders?.map(provider => provider.name || "").join(", ") || "";
            var oaiIds = result.oaiIds?.map(id => id.value || "").join(", ") || "";
            var identifiers = result.identifiers?.map(identifier => identifier.value || "").join(", ") || "";

            // Append cleaned values to the spreadsheet
            sheet.appendRow([
              domain, // Base domain for grouping
              result.id || "",
              result.title || "",
              result.authors.map(author => author.name).join(", "),
              result.publisher || "",
              result.yearPublished || "",
              result.depositedDate || "",
              result.documentType || "",
              result.doi || "",
              result.oaiIds?.join(", ") || "",
              extractedUrls.join(", ") // Write full URLs found in fullText for human verification purposes
            ]);
          });

          // Extract new scrollId for pagination
          scrollId = data.scrollId || scrollId; 
          Logger.log(`Fetching next batch with scrollId: ${scrollId}`);

          if (!scrollId) {
            Logger.log("No scrollId received, stopping pagination.");
            moreData = false;
          }
        } else {
          moreData = false;
          Logger.log(`No more results found for ${domain}`);
        }

      } catch (e) {
        Logger.log(`Error fetching data for ${domain}: ` + e.message);
        moreData = false;
      }
    }
  });
}