# -*- coding: utf-8 -*-
"""
Created on Mon Jun  9 13:05:42 2025

@author: Daniel Kuznesof
"""


from hapi import *
import matplotlib.pyplot as plt
db_begin('data')
"""
fetch('CH4',6,1,1818,50000)
fetch('CO2',2,1,1818,50000)
fetch('CO',5,1,1818,50000)
fetch('H2O',1,1,1818,50000)
fetch('N2O',4,1,1818,50000)
fetch('SO2',9,1,1818,50000)
fetch('NO',8,1,1818,50000)
fetch('NH3',11,1,1818,50000)
"""

gases = {
    'CH4': (6, 1),
    'CO2': (2, 1),
    'CO': (5, 1),
    'H2O': (1, 1),
    'N2O': (4, 1),
    'SO2': (9, 1),
    'NO': (8, 1),
    'NH3': (11, 1),
}




# CH4
nu_CH4, coef_CH4 = absorptionCoefficient_Voigt(
    SourceTables=['CH4'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_CH4 = 1e4 / np.array(nu_CH4)
absorp_db_per_m_CH4 = coef_CH4 * 434.3


# CO2
nu_CO2, coef_CO2 = absorptionCoefficient_Voigt(
    SourceTables=['CO2'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_CO2 = 1e4 / np.array(nu_CO2)
absorp_db_per_m_CO2 = coef_CO2 * 434.3


# CO
nu_CO, coef_CO = absorptionCoefficient_Voigt(
    SourceTables=['CO'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_CO = 1e4 / np.array(nu_CO)
absorp_db_per_m_CO = coef_CO * 434.3


# H2O
nu_H2O, coef_H2O = absorptionCoefficient_Voigt(
    SourceTables=['H2O'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_H2O = 1e4 / np.array(nu_H2O)
absorp_db_per_m_H2O = coef_H2O * 434.3


# N2O
nu_N2O, coef_N2O = absorptionCoefficient_Voigt(
    SourceTables=['N2O'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_N2O = 1e4 / np.array(nu_N2O)
absorp_db_per_m_N2O = coef_N2O * 434.3


# SO2
nu_SO2, coef_SO2 = absorptionCoefficient_Voigt(
    SourceTables=['SO2'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_SO2 = 1e4 / np.array(nu_SO2)
absorp_db_per_m_SO2 = coef_SO2 * 434.3


# NO
nu_NO, coef_NO = absorptionCoefficient_Voigt(
    SourceTables=['NO'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_NO = 1e4 / np.array(nu_NO)
absorp_db_per_m_NO = coef_NO * 434.3


# NH3
nu_NH3, coef_NH3 = absorptionCoefficient_Voigt(
    SourceTables=['NH3'],
    HITRAN_units=True,
    Environment={'T': 296, 'p': 1.0},
)
wavelength_um_NH3 = 1e4 / np.array(nu_NH3)
absorp_db_per_m_NH3 = coef_NH3 * 434.3
# Create the figure and axis
# Set figure size for single-column width (85 mm)
fig_width_mm = 120  # Nature Photonics single-column width
fig_height_mm = fig_width_mm * 0.67  # Proportional height
fig_width_inches = fig_width_mm / 25.4  # Convert mm to inches
fig_height_inches = fig_height_mm / 25.4  # Convert mm to inches

# Create the figure and axis
fig, ax1 = plt.subplots(figsize=(fig_width_inches, fig_height_inches))
ax1.plot(wavelength_um_CH4, coef_CH4, label='CH4', alpha=0.7)

ax1.plot(wavelength_um_CO2, coef_CO2, label='CO2', alpha=0.7)
ax1.plot(wavelength_um_CO, coef_CO, label='CO', alpha=0.7)
#ax1.plot(wavelength_um_H2O, coef_H2O, label='H2O', alpha=0.7)
ax1.plot(wavelength_um_N2O, coef_N2O, label='N2O', alpha=0.7)
ax1.plot(wavelength_um_SO2, coef_SO2, label='SO2', alpha=0.7)
#ax1.plot(wavelength_um_NO, coef_NO, label='NO', alpha=0.7)
ax1.plot(wavelength_um_NH3, coef_NH3, label='NH3', alpha=0.7)

# Final plot formatting
ax1.set_xlabel("Wavelength (µm)")
ax1.set_ylabel("Absorption Coefficient (cm²/molecule)")
ax1.set_yscale("log")
ax1.legend(loc='upper left', fontsize=7)
ax1.set_xlim(3,5)

#ax1.tick_params(axis='both', which='major', labelsize=7)
ax1.set_ylim(1e-20,1e-16)
plt.tight_layout()
plt.show()