# -*- coding: utf-8 -*-
"""
Created on Fri Jun  6 15:34:20 2025

@author: Daniel Kuznesof
"""

from hapi import *

db_begin('data')
fetch('H2O',1,1,1818,50000)
fetch('O3',3,1,1818,50000)
fetch('N2',22,1,1818,50000)
fetch('O2',7,1,1818,50000)
fetch('CO2',2,1,1818,50000)
import matplotlib.pyplot as plt

Components = [
    (1, 1, 0.01),
    (3, 1, 0.000004),
    (22, 1, 0.78),
    (7, 1, 0.21),
    (2, 1, 0.0004)
]
getHelp(fetch)

"""
nu,coef = absorptionCoefficient_Lorentz(SourceTables='H2O', Diluent={'air':1.0})
nu,absorp = absorptionSpectrum(nu,coef)
plt.plot(nu,absorp)
"""



# Calculate absorption coefficient (cm²/molecule)
nu, coef = absorptionCoefficient_Voigt(
    Components=Components,
    SourceTables=['H2O', 'O3', 'N2', 'O2', 'CO2'],
    OmegaRange=[1820, 50000],
    OmegaStep=1,
    HITRAN_units=False,
    Environment={'T': 296, 'p': 1.0}
)

# Convert x-axis: Wavenumber [cm⁻¹] → Wavelength [μm]
wavelength_um = 1e4 / array(nu)
nu,absorp = absorptionSpectrum(nu,coef)
absorp_db_per_m = absorp * 434.3
# Plotting

solar_data = np.loadtxt('astmg173.csv', skiprows = 2, delimiter = ',')
wavelength = solar_data[:,0]/1000
irradiance = solar_data[:,3]

from matplotlib.ticker import ScalarFormatter
# Set figure size for single-column width (85 mm)
'''
fig_width_mm = 85  # Nature Photonics single-column width
fig_height_mm = fig_width_mm * 0.67  # Proportional height
fig_width_inches = fig_width_mm / 25.4  # Convert mm to inches
fig_height_inches = fig_height_mm / 25.4  # Convert mm to inches

# Create the figure and axis

fig, ax1 = plt.subplots(figsize=(fig_width_inches, fig_height_inches))
ax1.axhline(0.0004, color='gray', linestyle='--', linewidth=1, label='0.2 dB/km')

# Plot absorption
ax1.plot(wavelength_um, absorp_db_per_m, color='blue', label='Absorption (dB/m)', alpha = 0.6)
ax1.set_xlabel('Wavelength (μm)')
ax1.set_ylabel('Absorption (dB/m)')
#ax1.set_xscale('log')
ax1.set_yscale('log')
ax1.tick_params(axis='y')
ax1.set_ylim(1e-8,1e2)
ax1.set_xlim(0.3, 5)
ax1.set_xticks([1, 2, 3, 4, 5])
ax1.get_xaxis().set_major_formatter(ScalarFormatter())
# Secondary y-axis for solar irradiance
'''
# Set figure size for single-column width (85 mm)
fig_width_mm = 120  # Nature Photonics single-column width
fig_height_mm = fig_width_mm * 0.67  # Proportional height
fig_width_inches = fig_width_mm / 25.4  # Convert mm to inches
fig_height_inches = fig_height_mm / 25.4  # Convert mm to inches

wavelength_um = 1e4 / array(nu)
# Create the figure and axis
fig, ax1 = plt.subplots(figsize=(fig_width_inches, fig_height_inches))
#ax1.axhline(0.0004, color='gray', linestyle='--', linewidth=1, label='0.2 dB/km')

# Plot absorption
ax1.plot(wavelength_um, absorp_db_per_m, color='blue', label='Absorption (dB/m)', alpha = 0.6)
ax1.set_xlabel('Wavelength (μm)')
ax1.set_ylabel('Absorption (dB/m)')
#ax1.set_xscale('log')
ax1.set_yscale('log')
ax1.tick_params(axis='y')
ax1.set_ylim(1e-8,1e2)
ax1.set_xlim(0.3, 5)
ax1.set_xticks([1, 2, 3, 4, 5])
ax1.get_xaxis().set_major_formatter(ScalarFormatter())
# Secondary y-axis for solar irradiance
ax2 = ax1.twinx()
ax2.plot(wavelength, irradiance, color='red', label='Solar Irradiance')
ax2.set_ylabel('Solar Irradiance (W/m²/nm)')
#ax2.set_xscale('log')
ax2.tick_params(axis='y')
ax2.set_xticks([1, 2, 3, 4, 5])
ax2.get_xaxis().set_major_formatter(ScalarFormatter())

# --- Top x-axis: Photon Energy (eV) ---
def wavelength_to_energy(λ_um):
    return 1.239841984 / λ_um

def energy_to_wavelength(E_eV):
    return 1.239841984 / E_eV

secax = ax1.secondary_xaxis('top', functions=(wavelength_to_energy, energy_to_wavelength))
secax.set_xlabel('Photon Energy (eV)')


secax.xaxis.set_major_formatter(ScalarFormatter())
# Choose photon energy ticks that correspond to nice wavelength points
energy_ticks = wavelength_to_energy(np.array([1, 2, 3, 4, 5]))
energy_ticks = np.round(energy_ticks, 2)
secax.set_xticks(energy_ticks)

plt.tight_layout()
plt.show()

