# Load required libraries
library(raster)
library(sf)
library(ggplot2)
library(units)
library(rgeos)
library(sp)

# Set working directory
setwd("~/your_working_directory_folder")

# Load the flood extent raster here (e.g. Scenario a)
raster1 <- raster("/Users/Scenario_a.asc")

# Load the shapefiles here
# Boundary is the MHWS boundary shapefile available in 4_MHWS_extent folder
# Internvention is the intervention extent shapefiles available in 3_Intervention_extent folder
boundary <- shapefile("/Users/4_MHWS_extent/high_water_clipped.shp")
intervention <- shapefile("/Users/3_Intervention_extent/Scenario_a.shp")

# Set the CRS
crs_string <- "+init=EPSG:27700"
crs(raster1) <- crs_string
crs(boundary) <- crs_string
crs(intervention) <- crs_string

# Step 1: Mask to boundary and intervention
raster_cropped1 <- mask(raster1, boundary)

# Step 2: Create inverse mask of the intervention
# Rasterize the intervention polygon to match the cropped raster
intervention_raster <- rasterize(intervention, raster_cropped1, field = 1)

# Create inverse mask: TRUE where there's no intervention (i.e. outside)
intervention_inverse <- is.na(intervention_raster)

# Apply the inverse mask (this removes intervention area)
raster_cropped2 <- mask(raster_cropped1, intervention_inverse, maskvalue = 0)

# Step 3: Binarize the raster
raster_cropped2[!is.na(raster_cropped2)] <- 1
raster_cropped2[is.na(raster_cropped2)] <- 0

# Step 4: Count pixels with value 1
pixel_count <- sum(getValues(raster_cropped2) == 1, na.rm = TRUE)

# Step 5: Area calculation
area_m2 <- pixel_count * 20^2  # 20m x 20m resolution
area_km2 <- area_m2 / 1e6

# Output the result
print(paste("Flooded area OUTSIDE intervention:", round(area_km2, 3), "km²"))

# Plot the result
plot(raster_cropped2, main = "Flood Extent Outside Intervention Area")
