# ____________________________________________________________________________________________________________
# CODE FOR PAPER 1
# ____________________________________________________________________________________________________________
# ____________________________________________________________________________________________________________
# COMPARING TO OTHER UK ESTUARIES
# ____________________________________________________________________________________________________________

library(ggplot2)
library(readxl)
library(ggsci)
library(ggpubr)
library(ggridges)
library(e1071)
library(smatr)
library(gganimate)
library(dplyr)
library(transformr)
library(plotly)
library(viridisLite)
library(viridis)
library(writexl)
library(RColorBrewer)
library(scales)
library(ggpmisc)

# Set working directory
setwd("~/your_working_directory_folder")
# Import data
Analytical_numerical_small_Clyde <- read_excel("Analytical_numerical.xlsx")
Clyde <- subset(Analytical_numerical_small_Clyde, ID %in% c('Base case Clyde', 'Clyde 200 m wider', 'Clyde 200 m narrower', 'Base case Clyde numerical'))
Small <- subset(Analytical_numerical_small_Clyde, ID %in% c('Base case small estuary', 'Small estuary 200 m wider', 'Small estuary 200 m narrower'))

# Plot Clyde
Clydeplot <- ggplot(data = Clyde, aes(colour = ID)) +
  geom_line(aes(x = x, y = y)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Elevation [mAOD]",limits=c(5.2,5.9)) +
  scale_color_manual(values=c('black','#5755FF','red', '#83A660'))
Clydeplot

# Plot small estuary
smallplot <- ggplot(data = Small, aes(colour = ID)) +
  geom_line(aes(x = x, y = y)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Elevation [mAOD]",limits=c(5.2,5.9)) +
  scale_color_manual(values=c('black','red', '#83A660'))
smallplot
fig <- ggarrange (Clydeplot, smallplot,
                  labels = c("a", "b"),
                  ncol = 2, nrow = 1)
fig
ggsave(file="Analyticalnumerical.svg", plot=fig, width=6, height=3)

