# ____________________________________________________________________________________________________________
# CODE FOR PAPER 1
# ____________________________________________________________________________________________________________
# ____________________________________________________________________________________________________________
# COMPARING TO OTHER UK ESTUARIES
# ____________________________________________________________________________________________________________

library(ggplot2)
library(readxl)
library(ggsci)
library(ggpubr)
library(ggridges)
library(e1071)
library(smatr)
library(gganimate)
library(dplyr)
library(transformr)
library(plotly)
library(viridisLite)
library(viridis)
library(writexl)
library(RColorBrewer)
library(scales)
library(ggpmisc)
library(wesanderson)
library(ghibli)
library(palettetown)

# Set working directory
setwd("~/your_working_directory_folder")
# Import Table S4
S4 <- read_excel("Table_S4.xlsx", skip = 1)
S4Clyde <- S4[S4$Estuary %in% c('Clyde'),]
S4WOClyde <- S4[!S4$Estuary %in% c('Clyde'),]

mononoke_palette <- ghibli_palette("MononokeMedium")
extended_palette <- colorRampPalette(mononoke_palette)(12)


# Compare absolute estuary area vs flood reduction
abs <- ggplot(S4, aes(`Area [km2]`,`Relative flood reduction [%]`,na.rm=TRUE, label=Estuary)) +
  stat_smooth(method = "lm", formula = y ~ log(x)) +
  stat_regline_equation(
    aes(label =  paste(..eq.label.., ..adj.rr.label.., sep = "~~~~")),
    formula=y ~ log(x)) +
  geom_point(data = S4WOClyde, size=3,aes(colour=S4WOClyde$Estuary)) +
  geom_point(data = S4Clyde,size=3, colour="black") +
  geom_text(check_overlap = TRUE, vjust = -1, size =2) +
  geom_hline(yintercept = 0, linetype="dashed") +
  scale_x_continuous(name="Estuary size [km2]") +
  scale_y_continuous(name="Relative flood reduction [-]", limits=c(-0.1,0.6)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title.x=element_text(size=10, colour = "black"),
        axis.title.y=element_text(size=10, colour = "black"),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_colour_manual(values = extended_palette)

abs

# Compare relative estuary area vs flood reduction
rel <- ggplot(S4, aes(`Relative space given for flooding [%]`,`Relative flood reduction [%]`,na.rm=TRUE, label=Estuary)) +
  stat_smooth(method = "lm", formula = y ~ x) +
  stat_regline_equation(
    aes(label =  paste(..eq.label.., ..adj.rr.label.., sep = "~~~~")),
    formula=y ~ x) +
  geom_point(data = S4WOClyde, size=3,aes(colour=S4WOClyde$Estuary)) +
  geom_point(data = S4Clyde,size=3, colour="black") +
  geom_text(check_overlap = TRUE, vjust = -1,size =2) +
  geom_hline(yintercept = 0, linetype="dashed") +
  scale_x_continuous(name="Relative space [%]") +
  scale_y_continuous(name="Relative flood reduction [-]", limits=c(-0.1,0.6)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title.x=element_text(size=10, colour = "black"),
        axis.title.y=element_text(size=10, colour = "black"),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_colour_manual(values = extended_palette)

rel

fig <- ggarrange (abs, rel,
                  labels = c("a", "b"),
                  ncol = 2, nrow = 1)
fig
ggsave(file="Fig4rev3.svg", plot=fig, width=6, height=3)


# Plot the Clyde only
Clyde <- ggplot(S4Clyde, aes(`Relative space given for flooding [%]`,`Relative flood reduction [%]`,na.rm=TRUE, label=Estuary)) +
  stat_smooth(method = "lm", formula = y ~ x) +
  stat_regline_equation(
    aes(label =  paste(..eq.label.., ..adj.rr.label.., sep = "~~~~")),
    formula=y ~ x) +
  geom_point(data = S4Clyde,size=3, colour="black") +
  geom_text(check_overlap = TRUE, vjust = -1,size =2) +
  geom_hline(yintercept = 0, linetype="dashed") +
  scale_x_continuous(name="Relative space [%]") +
  scale_y_continuous(name="Relative flood reduction [-]", limits=c(-0.1,0.2)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title.x=element_text(size=10, colour = "black"),
        axis.title.y=element_text(size=10, colour = "black"),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_colour_manual(values = extended_palette)

Clyde
ggsave(file="Rightsize_Clyde.svg", plot=Clyde, width=3, height=3)
