# ____________________________________________________________________________________________________________
# CODE FOR PAPER 1
# ____________________________________________________________________________________________________________
# ____________________________________________________________________________________________________________
# LONGITUDINAL SECTION DIFFERENCE
# ____________________________________________________________________________________________________________

library (raster)
library (sf)
library (ggplot2)
library (units)
library (rgeos)
library (sp)
library (raster)
library (ggplot2)
library (readr)
library (ggstream)
library(dplyr)
library(zoo)
library(ggsci)
library(ggplot2)
library(gridExtra)
library(ggpubr)
library(paletteer)
library(readxl)
library(tidyverse)
library(ggpubr)
library(ggplot2)
library(paletteer)
library(ggsci)
library(gridExtra)
 
# Set working directory
setwd("~/your_working_directory_folder")

# For MAXIMUM WATER LEVEL, you can change last name to XXX_Max_1.asc
# Import minimum water level
basecase <- read_csv("Long_profile_Clyde_Basecase_low_tide.csv")
basecaseSLR <- read_csv("Long_profile_Clyde_Basecase'_low_tide.csv")
a <- read_csv ("Long_profile_Clyde_Scenario_a_low_tide.csv")
aSLR <- read_csv("Long_profile_Clyde_Scenario_a'_low_tide.csv")
b <- read_csv ("Long_profile_Clyde_Scenario_b_low_tide.csv")
bSLR <- read_csv("Long_profile_Clyde_Scenario_b'_low_tide.csv")
c <- read_csv ("Long_profile_Clyde_Scenario_c_low_tide.csv")
cSLR <- read_csv("Long_profile_Clyde_Scenario_c'_low_tide.csv")
d <- read_csv ("Long_profile_Clyde_Scenario_d_low_tide.csv")
dSLR <- read_csv("Long_profile_Clyde_Scenario_d'_low_tide.csv")
e <- read_csv ("Long_profile_Clyde_Scenario_e_low_tide.csv")
eSLR <- read_csv("Long_profile_Clyde_Scenario_e'_low_tide.csv")

# Import maximum water level
basecasemax <- read_csv("Long_profile_Clyde_Basecase_high_tide.csv")
basecasemaxSLR <- read_csv("Long_profile_Clyde_Basecase'_high_tide.csv")
amax <- read_csv ("Long_profile_Clyde_Scenario_a_high_tide.csv")
amaxSLR <- read_csv("Long_profile_Clyde_Scenario_a'_high_tide.csv")
bmax <- read_csv ("Long_profile_Clyde_Scenario_b_high_tide.csv")
bmaxSLR <- read_csv("Long_profile_Clyde_Scenario_b'_high_tide.csv")
cmax <- read_csv ("Long_profile_Clyde_Scenario_c_high_tide.csv")
cmaxSLR <- read_csv("Long_profile_Clyde_Scenario_c'_high_tide.csv")
dmax <- read_csv ("Long_profile_Clyde_Scenario_d_high_tide.csv")
dmaxSLR <- read_csv("Long_profile_Clyde_Scenario_d'_high_tide.csv")
emax <- read_csv ("Long_profile_Clyde_Scenario_e_high_tide.csv")
emaxSLR <- read_csv("Long_profile_Clyde_Scenario_e'_high_tide.csv")

# Data wrangling
#Subset the data to only contain x and ymin
basecase <- basecase[,c(1,2,8)]
basecaseSLR <- basecaseSLR[,c(1,2,8)]
a <- a[,c(1,2,8)]
aSLR <- aSLR[,c(1,2,8)]
b <- b[,c(1,2,8)]
bSLR <- bSLR[,c(1,2,8)]
c <- c[,c(1,2,8)]
cSLR <- cSLR[,c(1,2,8)]
d <- d[,c(1,2,8)]
dSLR <- dSLR[,c(1,2,8)]
e <- e[,c(1,2,8)]
eSLR <- eSLR[,c(1,2,8)]

#Subset the data to only contain x and ymax
basecasemax <- basecasemax[,c(1,2,8)]
basecasemaxSLR <- basecasemaxSLR[,c(1,2,8)]
amax <- amax[,c(1,2,8)]
amaxSLR <- amaxSLR[,c(1,2,8)]
bmax <- bmax[,c(1,2,8)]
bmaxSLR <- bmaxSLR[,c(1,2,8)]
cmax <- cmax[,c(1,2,8)]
cmaxSLR <- cmaxSLR[,c(1,2,8)]
dmax <- dmax[,c(1,2,8)]
dmaxSLR <- dmaxSLR[,c(1,2,8)]
emax <- emax[,c(1,2,8)]
emaxSLR <- emaxSLR[,c(1,2,8)]

# Change the header of the needed column
colnames(basecase) [1] <- "x"
colnames(basecase) [2] <- "bed"
colnames(basecase) [3] <- "ymin"
colnames(basecaseSLR) [1] <- "x"
colnames(basecaseSLR) [2] <- "bed"
colnames(basecaseSLR) [3] <- "ymin"
colnames(a) [1] <- "x"
colnames(a) [2] <- "bed"
colnames(a) [3] <- "ymin"
colnames(aSLR) [1] <- "x"
colnames(aSLR) [2] <- "bed"
colnames(aSLR) [3] <- "ymin"
colnames(b) [1] <- "x"
colnames(b) [2] <- "bed"
colnames(b) [3] <- "ymin"
colnames(bSLR) [1] <- "x"
colnames(bSLR) [2] <- "bed"
colnames(bSLR) [3] <- "ymin"
colnames(c) [1] <- "x"
colnames(c) [2] <- "bed"
colnames(c) [3] <- "ymin"
colnames(cSLR) [1] <- "x"
colnames(cSLR) [2] <- "bed"
colnames(cSLR) [3] <- "ymin"
colnames(d) [1] <- "x"
colnames(d) [2] <- "bed"
colnames(d) [3] <- "ymin"
colnames(dSLR) [1] <- "x"
colnames(dSLR) [2] <- "bed"
colnames(dSLR) [3] <- "ymin"
colnames(e) [1] <- "x"
colnames(e) [2] <- "bed"
colnames(e) [3] <- "ymin"
colnames(eSLR) [1] <- "x"
colnames(eSLR) [2] <- "bed"
colnames(eSLR) [3] <- "ymin"

colnames(basecasemax) [1] <- "x"
colnames(basecasemax) [2] <- "bed"
colnames(basecasemax) [3] <- "ymax"
colnames(basecasemaxSLR) [1] <- "x"
colnames(basecasemaxSLR) [2] <- "bed"
colnames(basecasemaxSLR) [3] <- "ymax"
colnames(amax) [1] <- "x"
colnames(amax) [2] <- "bed"
colnames(amax) [3] <- "ymax"
colnames(amaxSLR) [1] <- "x"
colnames(amaxSLR) [2] <- "bed"
colnames(amaxSLR) [3] <- "ymax"
colnames(bmax) [1] <- "x"
colnames(bmax) [2] <- "bed"
colnames(bmax) [3] <- "ymax"
colnames(bmaxSLR) [1] <- "x"
colnames(bmaxSLR) [2] <- "bed"
colnames(bmaxSLR) [3] <- "ymax"
colnames(cmax) [1] <- "x"
colnames(cmax) [2] <- "bed"
colnames(cmax) [3] <- "ymax"
colnames(cmaxSLR) [1] <- "x"
colnames(cmaxSLR) [2] <- "bed"
colnames(cmaxSLR) [3] <- "ymax"
colnames(dmax) [1] <- "x"
colnames(dmax) [2] <- "bed"
colnames(dmax) [3] <- "ymax"
colnames(dmaxSLR) [1] <- "x"
colnames(dmaxSLR) [2] <- "bed"
colnames(dmaxSLR) [3] <- "ymax"
colnames(emax) [1] <- "x"
colnames(emax) [2] <- "bed"
colnames(emax) [3] <- "ymax"
colnames(emaxSLR) [1] <- "x"
colnames(emaxSLR) [2] <- "bed"
colnames(emaxSLR) [3] <- "ymax"

# Append ymin ymax for each scenario
basecase <- data.frame(basecase,basecasemax$ymax)
colnames(basecase)[4] <- "ymax"
a <- data.frame(a,amax$ymax)
colnames(a)[4] <- "ymax"
b <- data.frame(b,bmax$ymax)
colnames(b)[4] <- "ymax"
c <- data.frame(c,cmax$ymax)
colnames(c)[4] <- "ymax"
d <- data.frame(d,dmax$ymax)
colnames(d)[4] <- "ymax"
e <- data.frame(e,emax$ymax)
colnames(e)[4] <- "ymax"

basecaseSLR <- data.frame(basecaseSLR,basecasemaxSLR$ymax)
colnames(basecaseSLR)[4] <- "ymax"
aSLR <- data.frame(aSLR,amaxSLR$ymax)
colnames(aSLR)[4] <- "ymax"
bSLR <- data.frame(bSLR,bmaxSLR$ymax)
colnames(bSLR)[4] <- "ymax"
cSLR <- data.frame(cSLR,cmaxSLR$ymax)
colnames(cSLR)[4] <- "ymax"
dSLR <- data.frame(dSLR,dmaxSLR$ymax)
colnames(dSLR)[4] <- "ymax"
eSLR <- data.frame(eSLR,emaxSLR$ymax)
colnames(eSLR)[4] <- "ymax"

# Add new column to ID each profile
basecase$ID <- 'basecase'
basecaseSLR$ID <- "basecase'"
a$ID <- 'a'
aSLR$ID <- "a'"
b$ID <- 'b'
bSLR$ID <- "b'"
c$ID <- 'c'
cSLR$ID <- "c'"
d$ID <- 'd'
dSLR$ID <- "d'"
e$ID <- 'e'
eSLR$ID <- "e'"

# Append profiles based on SLR
profile <- bind_rows(basecase, a,
                  b, c, d, e)
profileSLR <- bind_rows(basecaseSLR, aSLR,
                    bSLR, cSLR, dSLR, eSLR)
# Export 800 x 250
# Plot the profiles
# Without SLR
LP <- ggplot(data = profile, aes(colour = profile$ID)) +
  geom_line(aes(x = x, y = ymin)) +
  geom_line(aes(x = x, y = ymax)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Elevation [mAOD]",limits=c(-2,6)) +
  scale_colour_paletteer_d("nationalparkcolors::BlueRidgePkwy")

# With SLR
LP_SLR <- ggplot(data = profileSLR, aes(colour = profile$ID)) +
  geom_line(aes(x = x, y = ymin)) +
  geom_line(aes(x = x, y = ymax)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Elevation [mAOD]",limits=c(-2,6)) +
  scale_colour_paletteer_d("nationalparkcolors::BlueRidgePkwy")

# Calculate tidal range
profile$TR <- profile$ymax - profile$ymin
profileSLR$TR <- profileSLR$ymax - profileSLR$ymin


# Plot the tidal ranges
# Without SLR
TR <- ggplot(data = profile, aes(colour = profile$ID)) +
  geom_line(aes(x = x, y = TR)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Tidal range [m]",limits=c(4.8,5.8)) +
  scale_colour_paletteer_d("nationalparkcolors::BlueRidgePkwy")

# With SLR
TR_SLR <- ggplot(data = profileSLR, aes(colour = profile$ID)) +
  geom_line(aes(x = x, y = TR)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Tidal range [m]",limits=c(4.8,5.8)) +
  scale_colour_paletteer_d("nationalparkcolors::BlueRidgePkwy")


# Calculate flood depth longitudinally
profile$wdepth <- profile$ymax - profile$bed
profileSLR$wdepth <- profileSLR$ymax - profileSLR$bed

depth <- ggplot(data = profile, aes(colour = profile$ID)) +
  geom_line(aes(x = x, y = wdepth)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Water depth [mAOD]", limits=c(6,18)) +
  scale_colour_paletteer_d("nationalparkcolors::BlueRidgePkwy")
depth

depth_SLR <- ggplot(data = profileSLR, aes(colour = profile$ID)) +
  geom_line(aes(x = x, y = wdepth)) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_continuous(name="Longitudinal distance [m]") +
  scale_y_continuous(name="Water depth [mAOD]", limits=c(6,18)) +
  scale_colour_paletteer_d("nationalparkcolors::BlueRidgePkwy")
depth_SLR
fig <- ggarrange (LP, LP_SLR,
                  TR, TR_SLR,
                  TRbox, TRboxSLR,
                  labels = c("a", "b", "c", "d","e","f"),
                  ncol = 2, nrow = 3)
fig
ggsave(file="LPTRWD_rev1.svg", plot=fig, width=9, height=6)


# Plot TR boxplots per scenario

# Add ID SLR and No SLR
profile$SLR <- 'No SLR'
profileSLR$SLR <- 'SLR'
prof <- bind_rows(profile, profileSLR)

# Without SLR
TRbox <- ggplot(profile, aes(x=ID, y=TR, fill=ID)) +
  geom_boxplot(lwd = 0.2) +
  stat_boxplot(geom = "errorbar", width = 0.15) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_discrete(limits = c('a','b','c','d','e','basecase'),name="Scenario") +
  scale_y_continuous(name="Tidal range [m]",limits=c(4.8,5.8)) +
  scale_fill_paletteer_d("nationalparkcolors::BlueRidgePkwy")
TRbox

# With SLR
TRboxSLR <- ggplot(profileSLR, aes(x=ID, y=TR, fill=ID)) +
  geom_boxplot(lwd = 0.2) +
  stat_boxplot(geom = "errorbar", width = 0.15) +
  theme(axis.text=element_text(size=10, colour = "black"),
        axis.title=element_text(size=10),
        panel.border = element_rect(colour = "black", fill=NA, size=1),
        panel.background=element_rect("white"),
        panel.grid.major = element_line("white"),
        legend.position = "none") +
  scale_x_discrete(limits = c("a'","b'","c'","d'","e'","basecase'"),name="Scenario") +
  scale_y_continuous(name="Tidal range [m]",limits=c(4.8,5.8)) +
  scale_fill_paletteer_d("nationalparkcolors::BlueRidgePkwy")
TRboxSLR

fig <- ggarrange (TRbox, TRboxSLR,
                  labels = c("a", "b"),
                  ncol = 2, nrow = 1)
fig
ggsave(file="TRbox.svg", plot=fig, width=8, height=2)

# Calculate tidal range change without SLR
mean(profile[profile$ID == 'basecase','TR'])
mean(profile[profile$ID == 'basecase','TR']) - mean(profile[profile$ID == 'a','TR'])
mean(profile[profile$ID == 'basecase','TR']) - mean(profile[profile$ID == 'b','TR'])  
mean(profile[profile$ID == 'basecase','TR']) - mean(profile[profile$ID == 'c','TR'])
mean(profile[profile$ID == 'basecase','TR']) - mean(profile[profile$ID == 'd','TR'])
mean(profile[profile$ID == 'basecase','TR']) - mean(profile[profile$ID == 'e','TR'])

# Calculate tidal range change with SLR
mean(profileSLR[profileSLR$ID == 'basecaseSLR','TR'])
mean(profileSLR[profileSLR$ID == 'basecaseSLR','TR']) - mean(profileSLR[profileSLR$ID == 'aSLR','TR'])
mean(profileSLR[profileSLR$ID == 'basecaseSLR','TR']) - mean(profileSLR[profileSLR$ID == 'bSLR','TR'])  
mean(profileSLR[profileSLR$ID == 'basecaseSLR','TR']) - mean(profileSLR[profileSLR$ID == 'cSLR','TR'])
mean(profileSLR[profileSLR$ID == 'basecaseSLR','TR']) - mean(profileSLR[profileSLR$ID == 'dSLR','TR'])
mean(profileSLR[profileSLR$ID == 'basecaseSLR','TR']) - mean(profileSLR[profileSLR$ID == 'eSLR','TR'])

