#Code accompanying the paper, "Phenotypic plasticity as a route to population shifts via tipping points".
#Used to run the simulations for Lucilia cuprina with slowly varying adult food supply. Requires Blowfly.jl


include("Blowfly.jl");
using Plots,DelimitedFiles

#Parameters for the run
ChangeSpeed =0.01;
Start=390;
End=450;
file=string(Start,"to",End,"_speed",ChangeSpeed,"/");


LeadIn   =2000;
saveat=1;

ChangeTime=abs(End-Start)/ChangeSpeed;
CutOff=LeadIn;
tspan=LeadIn+2*ChangeTime;

times=[tspan,LeadIn,ChangeTime]
EndPoints=[Start,End]

fn=string(file,string("Simulation.csv"));
args=[fn,times,CutOff,EndPoints,saveat]

mkpath(file)
writedlm(string(file,"ParamValues.csv"), [LeadIn,ChangeSpeed,Start,End,saveat])

#Function for linear changes to adult food with a lead in
function KA(t,args)
    #args = 1fn, 2.1 TotalTime, 2.2 LeadIn, 2.3 ChangeTime, 3CutOff, 4.1 Start, 4.2 End,
    if t.<args[2][2]
        return args[4][1];
    elseif t.<args[2][2]+args[2][3]
        return args[4][1].+(t.-args[2][2])*(args[4][2]-args[4][1])/args[2][3];
    else
        return  args[4][2].+(t.-args[2][2]-args[2][3])*(args[4][1]-args[4][2])/args[2][3];
    end
end

println(string("Starting the analysis"))
Blowfly.Run(KA,args);
println("Finished run.")
