####take trimmed and filtered reads and run Salmon using ONT mode
#!/bin/bash
mkdir Minimap/
mkdir Samtools/
mkdir Salmon/
#build index for reference sequence using minimap with soft-clipping for Salmon's ONT mode
minimap2 -t 8 -Y -I 1000G -d ./ReferenceData/transcript.mmi ./ReferenceData/transcript.fna
#loop through barcodes and run Salmon quant for each
for infile in ./InputData/Combined/*.fastq.gz; do
    base=$(basename -s '.fastq.gz' ${infile})
    echo $base
    # align to reference sequence
    minimap2 -t 8 -a -x map-ont -p 1.0 -N 100 ./ReferenceData/transcript.mmi ${infile} | samtools view -Sb > Minimap/${base}.bam
    # some useful stats
    samtools flagstat Minimap/${base}.bam > Samtools/${base}.flagstat
    # count reads
    salmon quant --ont -p 8 -t ./ReferenceData/transcript.fna ./ReferenceData/annotation.gff -l U -a Minimap/${base}.bam -o Salmon/${base}
done