# Alternative splicing analysis script 
# by ~J.
# for analysis of AS in pregnant Z. vivipara oviduct (WV)

####~load libraries~~~~~~~~~~####
library(IsoformSwitchAnalyzeR)
library(ggplot2)
library(svglite)
library(topGO)

####~housekeeping~~~~~~~~~~~~####
rm(list=ls()) #clear the environment
setwd(dirname(rstudioapi::getActiveDocumentContext()$path)) #set wd to Scripts folder
GO_file="../02_reference_data/gene2GO.map"
anal_dirs=(c("../08_dtu_preg_v_pre/","../09_dtu_preg_v_post/","../10_dtu_post_v_pre/"))

####~start loop~~~~~~~~~~~~~~####

for (anal_dir in anal_dirs) {
setwd(anal_dir) #set the new output directory as the working directory

####~re-load switch list~~~~~####
load(file = "mySwitchList.Rdata")

####~re-integrate x-tools~~~~####

###~~CPC2~~~~~~~~~~~~~~~~~~~~#### - stinky
#mySwitchList = analyzeCPC2(
#  switchAnalyzeRlist = mySwitchList,
#  pathToCPC2resultFile = "x_tools/CPC2.txt",
#  removeNoncodinORFs = FALSE
#)

###~~PFAM~~~~~~~~~~~~~~~~~~~~####
mySwitchList = analyzePFAM(
  switchAnalyzeRlist = mySwitchList,
  pathToPFAMresultFile = "x_tools/PFAM.txt",
  showProgress = FALSE
)

###~~SignalP~~~~~~~~~~~~~~~~~####
mySwitchList = analyzeSignalP(
  switchAnalyzeRlist = mySwitchList,
  pathToSignalPresultFile = "x_tools/SignalP.txt"
)

###~~IUPred2A~~~~~~~~~~~~~~~~####
mySwitchList <- analyzeIUPred2A(
  switchAnalyzeRlist        = mySwitchList,
  pathToIUPred2AresultFile = "x_tools/IUPred2A.result",
  showProgress = FALSE
)

###~~DeepTMHMM~~~~~~~~~~~~~~~####
mySwitchList = analyzeDeepTMHMM(
  switchAnalyzeRlist = mySwitchList,
  pathToDeepTMHMMresultFile = "x_tools/analyzeDeepTMHMM.gff3",
  showProgress = FALSE
)

###~~DeepLoc2~~~~~~~~~~~~~~~~####
mySwitchList = analyzeDeepLoc2(
  switchAnalyzeRlist = mySwitchList,
  pathToDeepLoc2resultFile = "x_tools/analyzeDeepLoc2.csv",
  quiet = FALSE
)

####~load relevant genes~~~~~####
genes = read.delim("DTU_gene_list.txt", header = FALSE)
genes = genes$V1
genes = as.list(genes)

####~switch plots~~~~~~~~~~~~####
dir.create("switch_plots")
mySwitchList$isoformFeatures$gene_name = mySwitchList$isoformFeatures$gene_id #fixes gene names for figures

switchItUp = function(g) {
  pdf(file = paste("./switch_plots/",g,"_switch.pdf"), onefile = FALSE, height=6, width = 9)
  switchPlot(mySwitchList, gene = g)
  dev.off()
}
switchItOn = function(g) {
  tx = switchPlotTranscript(mySwitchList, gene = g)
  ggsave(paste("./switch_plots/",g,"_transcript.svg"), plot = tx, height = 3, width = 9)
  ge = switchPlotGeneExp(mySwitchList, gene = g)
  ggsave(paste("./switch_plots/",g,"_gene.svg"), plot = ge, height = 3, width = 3)
  ie = switchPlotIsoExp(mySwitchList, gene = g)
  ggsave(paste("./switch_plots/",g,"_iso_exp.svg"), plot = ie, height = 3, width = 3)
  iu = switchPlotIsoUsage(mySwitchList, gene = g)
  ggsave(paste("./switch_plots/",g,"_iso_usg.svg"), plot = iu, height = 3, width = 3)
}

lapply(genes, switchItUp)
lapply(genes, switchItOn)

####~save dtu summary~~~~~~~~####
dtu_results = mySwitchList$isoformFeatures
write.csv(dtu_results, "dtu_res.csv", row.names = FALSE)
save(mySwitchList, file = "switchListAnalysed.Rdata")

####~GO term analysis~~~~~~~~####

###~~build universe~~~~~~~~~~####
salmon = read.csv("salmon_gene_transcript_counts.csv")
gene_universe = unique(salmon$gene_id)

###~~build gene list~~~~~~~~~####
genes = unlist(genes)
geneList = factor(as.integer(gene_universe %in% genes))
names(geneList) = gene_universe

###~~build topGOdata object~~####
gene2GO = readMappings(GO_file) #read in gene2GO object from file
GOdata = new("topGOdata", 
            ontology = "BP", 
            description = paste("GO term analysis (BP) for DTU genes: PREGvPRE"),
            allGenes = geneList,
            annot = annFUN.gene2GO,
            gene2GO = gene2GO)

###~~enrichment testing~~~~~~####
##~~~Fisher classic~~~~~~~~~~####
resultFisher = runTest(GOdata, algorithm = "classic", statistic = "fisher") #get test result
resultFisher.stats = geneData(resultFisher) #get stats for the test - sig GO terms is no. 4 here
resultFisher

##~~~Fisher weight~~~~~~~~~~~####
resultWeight = runTest(GOdata, algorithm = "weight", statistic = "fisher")
resultWeight.stats = geneData(resultWeight)
resultWeight

##~~~Fisher elim~~~~~~~~~~~~~####
resultElim = runTest(GOdata, algorithm = "elim", statistic = "fisher")
resultElim.stats = geneData(resultElim)
resultElim

##~~~KS elim~~~~~~~~~~~~~~~~~####
resultElimKS = runTest(GOdata, algorithm = "elim", statistic = "ks")
resultElimKS.stats = geneData(resultElimKS)
resultElimKS

###~~all significant nodes~~~####
GO_sig = GenTable(GOdata, 
                  weight = resultWeight,
                  classic = resultFisher, 
                  elim = resultElim,
                  elim_ks = resultElimKS,
                  orderBy = "weight", 
                  ranksOf = "weight", 
                  topNodes = resultFisher.stats[4],
                  numChar = 1000) 
write_csv(GO_sig, "topGO_sig.csv")

###~~nodes graphs~~~~~~~~~~~~####
##~~~classic~~~~~~~~~~~~~~~~~####
printGraph(GOdata, 
           resultFisher, 
           firstSigNodes = 5, 
           fn.prefix = "DTU_PREGvPRE", 
           useInfo = "all", 
           pdfSW = TRUE)

##~~~~weight~~~~~~~~~~~~~~~~~####
printGraph(GOdata,
           resultWeight,
           firstSigNodes = 5,
           fn.prefix = "DTU_PREGvPRE",
           useInfo = "all",
           pdfSW = TRUE)

##~~~~elim~~~~~~~~~~~~~~~~~~~####
printGraph(GOdata,
           resultElim,
           firstSigNodes = 5,
           fn.prefix = "DTU_PREGvPRE",
           useInfo = "all",
           pdfSW = TRUE)

##~~~~weight~~~~~~~~~~~~~~~~~####
printGraph(GOdata,
           resultElimKS,
           firstSigNodes = 5,
           fn.prefix = "DTU_PREGvPRE_KS",
           useInfo = "all",
           pdfSW = TRUE)

###~~print file~~~~~~~~~~~~~~####
sink(NULL, type = "output") #disables the log - this causes issues!
sink("GO_enrichment_tests.txt")
print("Details of topGOdata object")
GOdata #print summary of GOdata object
print("Results summary:")
resultFisher
resultWeight
resultElim
resultElimKS
sink()

####~close loop~~~~~~~~~~~~~~####
}

####~fin~~~~~~~~~~~~~~~~~~~~~####
closeAllConnections()